/*
 * Examples  : Arduino Experiment Examples By....ETT CO.,LTD
 * Hardware  : ET-BASE AVR EASY MEGA328(Arduino)
 *           : ET-MINI W5100(Select VCC = +5V)
 *           : MOSI -> MOSI(PB3)       = Digital-11          
 *           : MISO <- MISO(PB4)       = Digital-12          
 *           : SCLK -> SCK(PB5)        = Digital-13           
 *           : CS#  -> SS#(PB2)        = Digital-10          
 *           : LED  -> Output Pin(PB1) = Digital-9     
 * Function  : Webserver Control LED
 *

Original code from http://www.arduinoprojectshq.com

Modified for ET-BASE AVR EASY328 and ET-MINI W5100

*/

#include <SPI.h>
#include <Ethernet.h>

byte mac[] = { 0xDE, 0xAD, 0xBE, 0xEF, 0xFE, 0xED };
IPAddress ip(192,168,1,177);

EthernetServer server(80);

void setup()
{
  Serial.begin(9600);    
  pinMode(9, OUTPUT);    
  Ethernet.begin(mac, ip);
  server.begin();
}

void loop()
{
  
  EthernetClient client = server.available();
  if (client) {
    boolean currentLineIsBlank = true;
    String buffer = "";  
    while (client.connected()) {
      if (client.available()) {
        char c = client.read();
        Serial.print(c);   
        buffer+=c;       
        if (c == '\n' && currentLineIsBlank) {
          
          client.println("HTTP/1.1 200 OK");
          client.println("Content-Type: text/html");
          client.println();
          client.println("<html>");
                           
          client.println("<h1><font color=\"blue\">Embedded Web Server</font></h1>");
          client.println("<h3><font color=\"blue\">ET-BASE AVR EASY328 and ET-MINI W5100</font></h3>");
         
          if (digitalRead(9)){  
            client.print(" LED D9 is <font color=\"green\"><b>ON</b></font>");
          }else{
            client.print(" LED D9 is <font color=\"red\"><b>OFF</b></font>");
          }
          client.println("<br />");
          
          
          //client.print("<FORM action=\"http://192.168.1.177/\" >");
          client.print("<FORM action=\"\">");
          client.print("<P> <INPUT type=\"radio\" name=\"status\" value=\"1\">ON");
          client.print("<P> <INPUT type=\"radio\" name=\"status\" value=\"0\">OFF");
          client.print("<P> <INPUT type=\"submit\" value=\"Submit\"> </FORM>");
          
          client.println("</html>");    
          break;
        }
        if (c == '\n') {
          
          currentLineIsBlank = true;
          buffer="";       
        } else if (c == '\r') {            
          if(buffer.indexOf("GET /?status=1")>=0)
            digitalWrite(9,HIGH);  
          
          if(buffer.indexOf("GET /?status=0")>=0)
            digitalWrite(9,LOW);  
        }
        else {
          
          currentLineIsBlank = false;
        }
      }
    }
    
    delay(1);
    
    client.stop();
  }
}

